#include "parsedemo_qw.h"

parsedemo_qw::parsedemo_qw(char* in_buf, long in_buf_len)
{
	buf		= in_buf;
	buf_len	= in_buf_len;
	block_count = 0;
}

parsedemo_qw::~parsedemo_qw()
{

}

void parsedemo_qw::log (demodata* in_data, configdata* in_config) {
	int i = 0;
	int j;
	unsigned long blocks = 0;
	unsigned long clientblocks = 0;
	unsigned long specialblocks = 0;
	unsigned long gameblocks = 0;
	char* pos;
	bool nodemo = false;
	float time;
	float starttime;
	char code;
	long blocksize;
    unsigned long seq_hid_1;
    unsigned long seq_hid_2;
    unsigned long seq1;
    unsigned long seq2;
    char special_id;
	char messages[QW_MAX_BLOCKLEN];
    char special_data[QW_MAX_BLOCKLEN];
	long          load;
	vec3_t        angles;
	short         speed[3];
	unsigned char flag;
	unsigned char impulse;
	vec3_t        uk_angles;
	
	pos = buf;
	data = in_data;
	config = in_config;
	
	while (pos < buf+buf_len) {
		j = 0;
		time = msg->ReadFloat (&pos);
		if (blocks == 0) starttime = time * 10;
		code = msg->ReadChar (&pos);
		switch (code) {
		case '\x00': // client block
			clientblocks++;
			blocks++;
			pos += 36;
			break;
		case '\x01': // server block
			blocksize = msg->ReadLong (&pos);
			seq_hid_1 = msg->ReadLong (&pos);
			if (seq_hid_1 == 0xFFFFFFFF) { // special block
				specialblocks++;
				blocks++;
				special_id = msg->ReadChar (&pos);
				analyzeSpecialBlock (pos, blocksize - 5, blocks);
				pos += (blocksize - 5);
			} else { // game block
				gameblocks++;
				blocks++;
				seq_hid_2 = msg->ReadLong (&pos);
				analyzeGameBlock (pos, blocksize - 8, time);
				pos += (blocksize - 8);
			}
			break;
		case '\x02':
			blocks++;
			seq1 = (unsigned long) msg->ReadLong (&pos);
			seq2 = (unsigned long) msg->ReadLong (&pos);
			break;
		default:
			nodemo = true;
			break;
		}
	}
}

void parsedemo_qw::analyzeSpecialBlock (char* block, unsigned long len, int block_number) {
	static unsigned char prev_id = 0;
	unsigned char id = 0;
	char* pos = block;
	char* text;
	while (pos < block + len) {
		prev_id = id;
		id = msg->ReadByte (&pos);
//		printf ("\nspecialblock_id: %i", id); // DEBUG
		switch (id) {
		case '\x02':
			text=msg->ReadString (&pos);
			break;
		case '\x0A': // String "Server is full"???
			text=msg->ReadString (&pos);
			break;
		case '\x42':
			text=msg->ReadString (&pos);
			break;
		case '\x45':
			break;
		case '\x6A':
			break;
		case '\x6B':
			break;
		case '\x6E':
			text=msg->ReadString (&pos);
			break;
		default:
			return;
			// fuck, what is id 0xA0?
			// debug_writeblock (block, len);
			// err->msg_and_exit ("QWML: Unknown special_id (this_id: 0x%X prev_id: 0x%X!)", id, prev_id);
			// break;
		}
	}
}

void parsedemo_qw::analyzeGameBlock (char* block, unsigned long len, float time) {
	char tempstr[256] = "";
	static int map_filenames_found;
	static long StaticEntityCount = 0;
	static long killed_monsters = 0;
	static long found_secrets = 0;
	long playermodel = 0; // ???
	static unsigned char prev_id;
	unsigned char id = 0;
	unsigned char temp[4096]; // SIZE?
	int i, j;
	char* pos = block;
	while (pos < block + len) {
		prev_id = id;
		id = msg->ReadByte (&pos);
//		printf ("\ngameblock_id: %i", id); // DEBUG
		switch (id) {
		case '\x00':
			err->msg_and_exit ("QWML: this_id: 0x%X prev_id: 0x%X", id, prev_id);
			break;
		case '\x01':
		case '\x02':
			break;
		case '\x03':
			long index;
			long value;
			long playerstate[32];
			index = msg->ReadByte (&pos);
			//			if (index > 0x1F)
			//				err->msg_and_exit (33, "");
			value = msg->ReadByte (&pos);
			playerstate[index] = value;
			break;
		case '\x04':
		case '\x05':
			return; // ???
			break;
		case '\x06':
			float vol;
			float attenuation;
			long channel;
			long entity;
			long soundnum;
			vec3_t origin;
			long entity_channel; // combined variable
			entity_channel = msg->ReadShort (&pos);
			vol = entity_channel & 0x8000 ? (float) msg->ReadByte (&pos) / 255.0 : 1.0;
			attenuation = entity_channel & 0x4000 ? (float) msg->ReadByte (&pos) / 64.0 : 1.0;
			channel = entity_channel & 0x07;
			entity = (entity_channel >> 3) & 0x03FF;
			if (entity >= 0x0300) {
				err->msg_and_exit ("QWML: this_id: 0x%X prev_id: 0x%X", id, prev_id);
			}
			soundnum = msg->ReadByte (&pos);
			for (i=0 ; i<3 ; i++) origin[i] = msg->ReadCoord (&pos);
			break;
		case '\x07':
			return; // ???
			break;
		case '\x08':
			char* text;
			long level;
			level = msg->ReadByte (&pos);
			text = msg->ReadString (&pos);
			stringdown ((unsigned char*) text);
			if (tempstr[0] == 0) {
				strcpy (tempstr, text);
			} else {
				strcat (tempstr, text);
			}
			if (text[strlen(text)-1] == '\n') {
				text[strlen(text)-1] = 0;
				data->add ((int) (time*10), 1, tempstr, 0);
				tempstr[0] = 0;
			}
			break;
		case '\x09':
			text = msg->ReadString (&pos);
			break;
		case '\x0A':
			vec3_t angles;
			for (i=0 ; i<3 ; i++) angles[i] = msg->ReadAngle (&pos);
			break;
		case '\x0B':
			long serverversion;
			long age;
			char* game;
			long client;
			char* mapname;
			serverversion = msg->ReadLong (&pos);
			age = msg->ReadLong (&pos);
			game = msg->ReadString (&pos);
			client = msg->ReadByte (&pos);
			mapname = msg->ReadString (&pos);
			if (serverversion >= 25) {
				msg->ReadFloat (&pos);
				msg->ReadFloat (&pos);
				msg->ReadFloat (&pos);
				msg->ReadFloat (&pos);
				msg->ReadFloat (&pos);
				msg->ReadFloat (&pos);
				msg->ReadFloat (&pos);
				msg->ReadFloat (&pos);
				msg->ReadFloat (&pos);
				msg->ReadFloat (&pos);
			}
			break;
		case '\x0C':
			long style;
			char* string;
			style = msg->ReadByte (&pos);
			if (style>=64) {
				err->msg_and_exit ("QWML: this_id: 0x%X prev_id: 0x%X", id, prev_id);
			}
			string = msg->ReadString (&pos);
			break;
		case '\x0D':
			return; // ???
			break;
		case '\x0E':
			long xplayer;
			long frags;
			xplayer = msg->ReadByte (&pos);
			if (xplayer > QW_MAX_SCOREBOARD) {
				err->msg_and_exit ("QWML: this_id: 0x%X prev_id: 0x%X", id, prev_id);
			}
			frags = msg->ReadShort (&pos);
			break;
		case '\x0F':
			return; // ???
			break;
		case '\x10':
			long channel_entity; // combined variable
			channel_entity = msg->ReadShort (&pos);
			channel = channel_entity & 0x07;
			entity = (channel_entity >> 3) & 0x03FF;
			break;
		case '\x11':
		case '\x12':
			return; // ???
			break;
		case '\x13':
			long save;
			long take;
			save = msg->ReadByte (&pos);
			take = msg->ReadByte (&pos);
			for (i=0 ; i<3 ; i++) origin[i] = msg->ReadCoord (&pos);
			break;
		case '\x14':
			entity_t staticentities[128];
			long frame;
			if (StaticEntityCount > 127) {
				err->msg_and_exit ("QWML: this_id: 0x%X prev_id: 0x%X", id, prev_id);
			}
			staticentities[StaticEntityCount].modelindex = msg->ReadByte (&pos);
			staticentities[StaticEntityCount].frame = msg->ReadByte (&pos);
			staticentities[StaticEntityCount].colormap = msg->ReadByte (&pos);
			staticentities[StaticEntityCount].skin = msg->ReadByte (&pos);
			for (i=0 ; i<3 ; i++) {
				staticentities[StaticEntityCount].origin[i] = msg->ReadCoord (&pos);
				staticentities[StaticEntityCount].angles[i] = msg->ReadAngle (&pos);
			}
			StaticEntityCount++;
			break;
		case '\x15':
			return; // ???
			break;
		case '\x16':
			entity_t entities[449];
			entity = msg->ReadEntity (&pos);
			if (entity > 449) {
				err->msg_and_exit ("QWML: this_id: 0x%X prev_id: 0x%X", id, prev_id);
			}
			entities[entity].default_modelindex = msg->ReadByte (&pos);
			entities[entity].default_frame = msg->ReadByte (&pos);
			entities[entity].default_colormap = msg->ReadByte (&pos);
			entities[entity].default_skin = msg->ReadByte (&pos);
			for (i=0 ; i<3 ; i++) {
				entities[entity].default_origin[i] = msg->ReadCoord (&pos);
				entities[entity].default_angles[i] = msg->ReadAngle (&pos);
			}
			break;
		case '\x17':
			unsigned char entitytype;
			vec3_t trace_endpos;
			long count;
			entitytype = msg->ReadByte (&pos);
			switch (entitytype) {
			case 0:
			case 1:
			case 3:
			case 4:
			case 7:
			case 8:
			case 10:
			case 11:
			case 13:
				for (i=0 ; i<3 ; i++) origin[i] = msg->ReadCoord (&pos);
				break;
			case 5:
			case 6:
			case 9:
				entity = msg->ReadShort (&pos);
				for (i=0 ; i<3 ; i++) origin[i] = msg->ReadCoord (&pos);
				for (i=0 ; i<3 ; i++) trace_endpos[i] = msg->ReadCoord (&pos);
				break;
			case 2:
			case 12:
				count = msg->ReadByte (&pos);
				for (i=0 ; i<3 ; i++) origin[i] = msg->ReadCoord (&pos);
				break;
			default:
				err->msg_and_exit ("QWML: this_id: 0x%X prev_id: 0x%X", id, prev_id);
				break;
			}
			break;
			case '\x18':
			case '\x19':
				return; // ???
				break;
			case '\x1A':
				text = msg->ReadString (&pos);
				break;
			case '\x1B':
				killed_monsters++;
				break;
			case '\x1C':
				found_secrets++;
				break;
			case '\x1D':
				for (i=0 ; i<3 ; i++) origin[i] = msg->ReadCoord (&pos);
				soundnum = msg->ReadByte (&pos);
				vol = (float) msg->ReadByte (&pos) / 255.0;
				attenuation = (float) msg->ReadByte (&pos) / 64.0;
				break;
			case '\x1E':
				//			writegameblock (pos, block+len-pos);
				for ( i=0 ; i<3 ; i++) origin[i] = msg->ReadCoord (&pos);
				for ( i=0 ; i<3 ; i++) angles[i] = msg->ReadAngle (&pos);
				break;
			case '\x1F':
				text = msg->ReadString (&pos);
				break;
			case '\x20':
				long track;
				track = msg->ReadByte (&pos);
				break;
			case '\x21':
			case '\x22':
			case '\x23':
				break;
			case '\x24':
				long ping;
				xplayer = msg->ReadByte (&pos);
				if (xplayer > QW_MAX_SCOREBOARD) {
					err->msg_and_exit ("QWML: this_id: 0x%X prev_id: 0x%X", id, prev_id);
				}
				ping = msg->ReadShort (&pos);
				break;
			case '\x25':
				float entertime;
				xplayer = msg->ReadByte (&pos);
				if (xplayer > QW_MAX_SCOREBOARD) {
					err->msg_and_exit ("QWML: this_id: 0x%X prev_id: 0x%X", id, prev_id);
				}
				entertime = msg->ReadFloat (&pos);
				break;
			case '\x26':
				index = msg->ReadByte (&pos);
				if (index > 0x1F) {
					err->msg_and_exit ("QWML: this_id: 0x%X prev_id: 0x%X", id, prev_id);
				}
				value = msg->ReadLong (&pos);
				playerstate[index] = value;
				break;
			case '\x27':
				entity = msg->ReadEntity (&pos);
				break;
			case '\x28': // userinfo (player name, skin etc.)
				long user;
				xplayer = msg->ReadByte (&pos);
				user = msg->ReadLong (&pos);
				if (xplayer > QW_MAX_SCOREBOARD) {
					err->msg_and_exit ("QWML: this_id: 0x%X prev_id: 0x%X", id, prev_id);
				}
				text = msg->ReadString (&pos);
				i = misc->find_sub (0, text, strlen (text), "name\\", 5);
				j = misc->find_sub (0, text, strlen (text), "spectator\\", 10);
				if (i > -1) {
					j = 0;
					while ((text[i] != '\\') && (text[i] != 0) && (j <= 64)) {
						temp[j++] = text[i++];
					}
					temp[j] = 0;
					stringdown (temp);
					data->add ((int) (time*10), 5, temp, 0);
				}
				break;
			case '\x29':
				long size;
				long percent;
				char* downloadbuffer;
				size = msg->ReadShort (&pos);
				percent = msg->ReadByte (&pos);
				if (size == -1) {
					err->msg_and_exit ("QWML: this_id: 0x%X prev_id: 0x%X", id, prev_id);
				}
				downloadbuffer = new char[size];
				for ( i=0 ; i<size ; i++ ) {
					downloadbuffer[i] = msg->ReadByte (&pos);
				}
				delete[] downloadbuffer;
				break;
			case '\x2A':
				long mask;
				long mask2;
				unsigned char load;
				vec3_t speed;
				long flag;
				int fire;
				int jump;
				long impulse;
				vec3_t cspeed;
				long model;
				long uk_byte6;
				long weapon;
				long weaponframe;
				//			writegameblock (pos, block+len-pos);
				return; // DEBUG!!!
				xplayer = msg->ReadByte (&pos); // 1
				mask = msg->ReadShort (&pos); // 3
				for (i=0;i<3;i++) origin[i] = msg->ReadCoord (&pos); // 9
				frame = msg->ReadByte (&pos); // 10
				if (mask & 0x0001) ping = msg->ReadByte (&pos) * 0.001;        // 11
				if (mask & 0x0002) {                               
					mask2 = msg->ReadByte (&pos); // 12
					if (mask2 & 0x01) angles[0] = msg->ReadAngle16 (&pos);         // 14
					angles[1] = msg->ReadAngle16 (&pos); // 16
					if (mask2 & 0x02) angles[2] = msg->ReadAngle16 (&pos);         // 18
					if (mask2 & 0x04) speed[0] = msg->ReadByte (&pos);             // 19
					if (mask2 & 0x08) speed[1] = msg->ReadByte (&pos);             // 20
					if (mask2 & 0x10) speed[2] = msg->ReadByte (&pos);             // 21
					if (mask2 & 0x20) flag = msg->ReadByte (&pos);                 // 22
					fire = (flag & 0x01) ? 1 : 0;
					jump = (flag & 0x02) ? 1 : 0;
					if (mask2 & 0x40) impulse = msg->ReadByte (&pos);              // 23
					if (mask2 & 0x80) load = msg->ReadByte (&pos);                 // 24
				}
				if (mask & 0x0004) cspeed[0] = msg->ReadCoord (&pos);          // 26
				if (mask & 0x0008) cspeed[1] = msg->ReadCoord (&pos);          // 28
				if (mask & 0x0010) cspeed[2] = msg->ReadCoord (&pos);          // 30
				model = (mask & 0x0020) ? msg->ReadByte (&pos) : playermodel;  // 31
				uk_byte6 = (mask & 0x0040) ? msg->ReadByte (&pos) : 0;         // 32
				if (mask & 0x0080) weapon = msg->ReadByte (&pos);              // 33
				if (mask & 0x0100) weaponframe = msg->ReadByte (&pos);         // 34
				break;
			case '\x2B':
				typedef struct {
					vec3_t origin;
					float angle_1;
					float angle_2;
				} nail_t;
				long nailcount;
				nail_t nails[1000];
				nail_t* n;
				unsigned char b[5];
				int j;
				
				nailcount = msg->ReadByte (&pos);
				for (j=0,n=nails;j<nailcount;j++,n++) {
					for (i=0;i<5;i++) b[i] = msg->ReadByte (&pos);
					// 3 12 bit values
					n->origin[0] = (b[0] & 0xFF) | ((b[1] & 0x0F) << 8);
					n->origin[1] = ((b[1] & 0xF0) >> 4) | (b[2] << 4);
					n->origin[2] = (b[3] & 0xFF) | ((b[4] & 0x0F) << 8);
					// shift and scale to standard (even) coordinates
					for (i=0;i<3;i++) n->origin[i] = (n->origin[i] - 2048) * 2;
					// signed value in 4 bits
					n->angle_1 = (b[4] & 0xF0) >> 4;
					// respect the sign
					if (n->angle_1>=8) n->angle_1 = n->angle_1 - 16;
					// scale it
					n->angle_1 *= 360.0 / 16.0;
					n->angle_2 = msg->ReadAngle (&pos);
				}
				break;
			case '\x2C':
				long choke;
				choke = msg->ReadByte (&pos);
				break;
			case '\x2D':
				char* precache_models[256];
				long nummodels;
				long first;
				long last;
				if (serverversion >= 26) {
					char *text;
					first = msg->ReadByte (&pos);
					for ( i=0 ; i<256 ; i++ ) {
						text = msg->ReadString (&pos);
						if (strlen(text) == 0) break;
						precache_models[i] = strdup(text);
					}
					last = msg->ReadByte (&pos);
				}
				else {
					nummodels = 0;
					do {
						if (++nummodels > 255) {
							err->msg_and_exit ("QWML: this_id: 0x%X prev_id: 0x%X", id, prev_id);
						}
						precache_models[nummodels] = msg->ReadString (&pos);
					} while (*precache_models[nummodels]);
				}
				break;
			case '\x2E':
				char* precache_sounds[256];
				long numsounds;
				if (serverversion >= 26) {
					char *text;
					first = msg->ReadByte (&pos);
					for ( i= 0 ; i<256 ; i++ ) { 
						text = msg->ReadString (&pos);
						if (strlen(text) == 0) break;
						precache_sounds[i] = strdup (text);
					}
					last = msg->ReadByte (&pos);
				}
				else {
					numsounds = 0;
					do {
						if (++numsounds > 255) {
							err->msg_and_exit ("QWML: this_id: 0x%X prev_id: 0x%X", id, prev_id);
						}
						precache_sounds[numsounds] = msg->ReadString (&pos);
					} while (*precache_sounds[numsounds]);
				}
				break;
			case '\x2F':
				while (mask = msg->ReadShort (&pos)) {
					entity = mask & 0x01FF;
					mask &= 0xFE00;
					if (mask & 0x8000) mask |= msg->ReadByte (&pos);
					if (mask & 0x0004) entities[entity].modelindex = msg->ReadByte (&pos);
					if (mask & 0x2000) entities[entity].frame = msg->ReadByte (&pos);
					if (mask & 0x0008) entities[entity].colormap = msg->ReadByte (&pos);
					if (mask & 0x0010) entities[entity].skin = msg->ReadByte (&pos);
					if (mask & 0x0020) entities[entity].effects = msg->ReadByte (&pos);
					if (mask & 0x0200) entities[entity].origin[0] = msg->ReadCoord (&pos);
					if (mask & 0x0001) entities[entity].angles[0] = msg->ReadAngle (&pos);
					if (mask & 0x0400) entities[entity].origin[1] = msg->ReadCoord (&pos);
					if (mask & 0x1000) entities[entity].angles[1] = msg->ReadAngle (&pos);
					if (mask & 0x0800) entities[entity].origin[2] = msg->ReadCoord (&pos);
					if (mask & 0x0002) entities[entity].angles[2] = msg->ReadAngle (&pos);
				}
				break;
			case '\x30':
				frame = msg->ReadByte (&pos);
				while (mask = msg->ReadShort (&pos)) {
					entity = mask & 0x01FF;
					mask &= 0xFE00;
					//
					if (mask & 0x8000) mask |= msg->ReadByte (&pos);
					if (mask & 0x0004) entities[entity].modelindex = msg->ReadByte (&pos);
					if (mask & 0x2000) entities[entity].frame = msg->ReadByte (&pos);
					if (mask & 0x0008) entities[entity].colormap = msg->ReadByte (&pos);
					if (mask & 0x0010) entities[entity].skin = msg->ReadByte (&pos);
					if (mask & 0x0020) entities[entity].effects = msg->ReadByte (&pos);
					if (mask & 0x0200) entities[entity].origin[0] = msg->ReadCoord (&pos);
					if (mask & 0x0001) entities[entity].angles[0] = msg->ReadAngle (&pos);
					if (mask & 0x0400) entities[entity].origin[1] = msg->ReadCoord (&pos);
					if (mask & 0x1000) entities[entity].angles[1] = msg->ReadAngle (&pos);
					if (mask & 0x0800) entities[entity].origin[2] = msg->ReadCoord (&pos);
					if (mask & 0x0002) entities[entity].angles[2] = msg->ReadAngle (&pos);
				}
				break;
			case '\x31':
				float maxspeed;
				maxspeed = msg->ReadFloat (&pos);
				break;
			case '\x32':
				float gravity;
				gravity = msg->ReadFloat (&pos);
				break;
			case '\x33':
				char* varname;
				char* valstr;
				xplayer = msg->ReadByte (&pos);
				varname = msg->ReadString (&pos);
				valstr = msg->ReadString (&pos);
				strcpy ((char*) temp, valstr);
				stringdown (temp);
				if (strcmp (varname, "name") == 0) {
					data->add ((int) (time*10), 5, temp, 0);
				}
				break;
			case '\x34':
				char* name;
				name = msg->ReadString (&pos);
				valstr = msg->ReadString (&pos);
				break;
			case '\x35':
				xplayer = msg->ReadByte (&pos);
				if (xplayer > QW_MAX_SCOREBOARD) {
					err->msg_and_exit ("QWML: this_id: 0x%X prev_id: 0x%X", id, prev_id);
				}
				value = msg->ReadByte (&pos);
				break;
			default:
				return; 
				//			err->msg_and_exit ("QWML: this_id: 0x%X prev_id: 0x%X", id, prev_id);
				//			break;
		}
	}
}

void parsedemo_qw::stringdown (unsigned char* str) {
	int i = 0;
	while (str[i] != 0) {
		switch (str[i]) {
		case 16:
		case 144:
			str[i] = 91;
			break;
		case 17:
		case 145:
			str[i] = 93;
			break;
		case 128:
			str[i] = 60;
			break;
		case 129:
			str[i] = 61;
			break;
		case 130:
			str[i] = 62;
			break;
		default:
			if ((str[i] > 31) && (str[i] < 128)) break;
			if (str[i] > 160) {
				str[i] -= 128;
				break;
			}
			if ((str[i] > 17) && (str[i] < 28)) {
				str[i] += 30;
				break;
			}
			if ((str[i] > 145) && (str[i] < 156)) {
				str[i] -= 98;
				break;
			}
			if (str[i] > 13) {
				str[i] = '.';
				break;
			}
		}
		++i;
	}
}

